using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace Multiple_DataAdapter
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
        internal System.Windows.Forms.TextBox txtStateWanted;
        internal System.Windows.Forms.DataGrid DataGrid1;
        internal System.Windows.Forms.Button btnFind;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.txtStateWanted = new System.Windows.Forms.TextBox();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            this.btnFind = new System.Windows.Forms.Button();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // txtStateWanted
            // 
            this.txtStateWanted.Location = new System.Drawing.Point(40, 216);
            this.txtStateWanted.Name = "txtStateWanted";
            this.txtStateWanted.Size = new System.Drawing.Size(120, 20);
            this.txtStateWanted.TabIndex = 5;
            this.txtStateWanted.Text = "CA";
            // 
            // DataGrid1
            // 
            this.DataGrid1.AlternatingBackColor = System.Drawing.Color.OldLace;
            this.DataGrid1.BackColor = System.Drawing.Color.OldLace;
            this.DataGrid1.BackgroundColor = System.Drawing.Color.Tan;
            this.DataGrid1.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.DataGrid1.CaptionBackColor = System.Drawing.Color.SaddleBrown;
            this.DataGrid1.CaptionForeColor = System.Drawing.Color.OldLace;
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Top;
            this.DataGrid1.FlatMode = true;
            this.DataGrid1.Font = new System.Drawing.Font("Tahoma", 8F);
            this.DataGrid1.ForeColor = System.Drawing.Color.DarkSlateGray;
            this.DataGrid1.GridLineColor = System.Drawing.Color.Tan;
            this.DataGrid1.HeaderBackColor = System.Drawing.Color.Wheat;
            this.DataGrid1.HeaderFont = new System.Drawing.Font("Tahoma", 8F, System.Drawing.FontStyle.Bold);
            this.DataGrid1.HeaderForeColor = System.Drawing.Color.SaddleBrown;
            this.DataGrid1.LinkColor = System.Drawing.Color.DarkSlateBlue;
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.ParentRowsBackColor = System.Drawing.Color.OldLace;
            this.DataGrid1.ParentRowsForeColor = System.Drawing.Color.DarkSlateGray;
            this.DataGrid1.SelectionBackColor = System.Drawing.Color.SlateGray;
            this.DataGrid1.SelectionForeColor = System.Drawing.Color.White;
            this.DataGrid1.Size = new System.Drawing.Size(292, 176);
            this.DataGrid1.TabIndex = 4;
            // 
            // btnFind
            // 
            this.btnFind.Location = new System.Drawing.Point(176, 200);
            this.btnFind.Name = "btnFind";
            this.btnFind.Size = new System.Drawing.Size(80, 40);
            this.btnFind.TabIndex = 3;
            this.btnFind.Text = "Find";
            this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(292, 273);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.txtStateWanted,
                                                                          this.DataGrid1,
                                                                          this.btnFind});
            this.Name = "Form1";
            this.Text = "Form1";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        private void btnFind_Click(object sender, System.EventArgs e)
        {
            try
            {
                // Create a DataSet
                DataSet ds =new DataSet();
                
                // Create the DataAdapter providing connection and SELECT Command - For Publishers
                SqlDataAdapter da = new SqlDataAdapter("SELECT pubid, pubname, city, state "
                    +" FROM publishers WHERE state = @State", 
                    "data source=.;database=biblio;uid=admin;pwd=pw");

                // Initialize the Select Command Parameters - for Publishers (and Titles !)
                da.SelectCommand.Parameters.Add("@State", SqlDbType.VarChar, 2);
                da.SelectCommand.Parameters["@State"].Value = txtStateWanted.Text;

                // Fill the dataset with the results and name the Table "Publishers"
                da.Fill(ds, "Publishers");


                // Reuse the DataAdapter resetting the SELECT Command - For Titles
                da.SelectCommand.CommandText = "SELECT title, price, pubid FROM titles "
                    +" WHERE pubid in (SELECT pubid FROM publishers WHERE state = @State)";
                
                // Fill the DataSet with the results and name the Table "Titles"
                da.Fill(ds, "Titles");

                // Call our AddRelation() method to relate Publishers and Titles
                AddRelation(ds);

                // Bind the Publishers DataTable to the Grid
                DataGrid1.DataSource = ds.Tables["Publishers"];
            }
            catch (SqlException sex)
            {
                Debug.WriteLine(sex.ToString());
            }

        }

        private void AddRelation(DataSet ds)
        {
            try
            {
                // if we don't already have a relationship defined
                // then define one.
                if (ds.Relations.Count == 0)
                {

                    // Create new DataColumn objects for parent and child 
                    DataColumn parentCol = new DataColumn();
                    DataColumn childCol = new DataColumn();

                    // Declare a DataRelation object
                    DataRelation relPublishers;
                
                    // Assign the parent and child columns
                    parentCol = ds.Tables["Publishers"].Columns["PubID"];
                    childCol = ds.Tables["Titles"].Columns["PubID"];

                    // Create DataRelation.
                    relPublishers = new DataRelation("PublishersTitles", parentCol, childCol);
                
                    // Add the relation to the DataSet.
                    ds.Relations.Add(relPublishers);
                }
            }
            catch( Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }
	}
}
